/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.mixin.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.adventurez.access.EntityAccess;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.IronGolemCrackinessLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.IronGolem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={IronGolemCrackinessLayer.class})
public class IronGolemCrackFeatureRendererMixin {
    private static final Map<IronGolem.Crackiness, ResourceLocation> BLACKSTONED_CRACKINESS_TO_TEXTURE = ImmutableMap.of((Object)IronGolem.Crackiness.LOW, (Object)new ResourceLocation("adventurez:textures/entity/feature/iron_golem_blackstoned_low.png"), (Object)IronGolem.Crackiness.MEDIUM, (Object)new ResourceLocation("adventurez:textures/entity/feature/iron_golem_blackstoned_medium.png"), (Object)IronGolem.Crackiness.HIGH, (Object)new ResourceLocation("adventurez:textures/entity/feature/iron_golem_blackstoned_high.png"));

    @ModifyVariable(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/feature/IronGolemCrackFeatureRenderer;getContextModel()Lnet/minecraft/client/render/entity/model/EntityModel;"), ordinal=0)
    private ResourceLocation renderMixin(ResourceLocation original, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, IronGolem ironGolemEntity, float f, float g, float h, float j, float k, float l) {
        if (((Boolean)ironGolemEntity.m_20088_().m_135370_(((EntityAccess)ironGolemEntity).getTrackedDataBoolean())).booleanValue()) {
            return BLACKSTONED_CRACKINESS_TO_TEXTURE.get(ironGolemEntity.m_28873_());
        }
        return original;
    }
}

